#include <iostream>
#include <vector>
#include <cstdio>
#include <cstdlib>
#include <string>
#include <cmath>
#include <cassert>
#include <algorithm>
#include <set>
#include <map>

#define forn(i, n) for (int i = 0; i < (int)n; i++)
#define fore(i, b, e) for (int i = (int)b; i <= (int)e; i++)
#define fi first
#define se second
#define mp make_pair
#define pb push_back


#define POINT true
#define LINE false
#define TASKNAME "coco"

typedef long long i64;
typedef long long li;
typedef long long lint;

using namespace std;

struct Point
{
	double x, y;
	Point(){}
	Point(double _x, double _y) : x(_x), y(_y) {}
	void print()
	{
		printf("%.10lf %.10lf\n", x, y);
	}
};

struct Line
{
	double a, b, c;
	Line(){}
	Line(Point p1, Point p2)
	{
		a = p2.y - p1.y;
		b = p1.x - p2.x;
		c = -a * p1.x - b * p1.y;
	}
	void print()
	{
		printf(" (%.5lf %.5lf %.5lf)\n", a, b, c);
	}
};

Line operator * (Point first, Point second)
{
	return Line(first, second); 
}

Point operator * (Line l1, Line l2)
{
	double y = (l2.c * l1.a - l1.c * l2.a) / (l1.b * l2.a - l2.b * l1.a);
	double x = (l2.c * l1.b - l1.c * l2.b) / (l2.b * l1.a - l1.b * l2.a);
	return Point(x, y);
}

Point operator * (Point first, Line second)
{
	Point T(first.x + second.a, first.y + second.b);
	Line tmp(first, T);
	Point T2 = tmp * second;
	return Point(first.x + (T2.x - first.x) * 2, first.y + (T2.y - first.y) * 2);
}

Point operator * (Line first, Point second)
{
	return second * first;
}

struct Elem
{
	bool flag;
	Point point;
	Line line;
	Elem(Point p)
	{
		flag = POINT;
		point = p;
	}
	Elem(Line l)
	{
		flag = LINE;
		line = l;
	}
	Elem operator * (Elem an)
	{
		if (flag == POINT)
		{
			if (an.flag == POINT)
				return Elem(point * an.point);
			else return Elem(point * an.line);
		}
		else
		{
			if (an.flag == POINT)
				return Elem(line * an.point);
			else return Elem(line * an.line);
		}
	}
	void print()
	{
		if (flag == POINT)
		{
			printf("POINT ");
			point.print();
		}
		else
		{
			printf("LINE");
			line.print();
		}
	}
};

const int maxn = 1000;

int balance[maxn];

string s;

int get_number(int L, int R)
{
	int st = L;
	bool minus;
	if (s[L] == '-')
	{
		minus = true;
		st++;
	}
	else minus = false;
	int ret = 0;
	fore(pos, st, R)
		ret = ret * 10 + s[pos] - '0';
	if (minus)
		ret *= -1;
	return ret;
}

Elem get(int L, int R, int depth)
{
	int z = -1;
	fore(pos, L, R)
		if (s[pos] == ',' && balance[pos] == depth)
		{
			z = pos;
			break;
		}
	if (z != -1)
	{
		int t1 = get_number(L, z - 1);
		int t2 = get_number(z + 1, R);
		//printf("get (%d %d) point %d %d\n", L, R, t1, t2);
		return Elem(Point(t1, t2));
	}
	int start = L;
	vector <Elem> list;
	fore(pos, L, R)
		if (s[pos] == '@' && balance[pos] == depth)
		{
			list.pb(get(start, pos - 1, depth));
			start = pos + 1;
		}
	if (list.empty())
		return get(L + 1, R - 1, depth + 1);
	list.pb(get(start, R, depth));
	Elem cur = list[0];
	fore(j, 1, list.size() - 1)
		cur = cur * list[j];
	//printf("get %d %d ", L, R);
	//cur.print();
	return cur;
}

int main()
{
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);
	while(true)
	{
		cin >> s;
		if (s == "#")
			break;
		balance[0] = (s[0] == '(' ? 1 : 0);
		fore(j, 1, s.length() - 1)
		{
			balance[j] = balance[j - 1];
			if (s[j] == '(')
				balance[j]++;
			else if (s[j] == ')')
				balance[j]--;
		}
		
		Elem result = get(0, s.length() - 1, 0);
		result.point.print();
	}
}